
Declare Sub __Zoey_Globals_Configure ( __Alisha_ As __Alisha_Globals_Type )

Declare Sub __Zoey_Globals_Macros ( __Alisha_ As __Alisha_Globals_Type )

Sub __Zoey_Globals_Configure ( __Alisha_ As __Alisha_Globals_Type )

	__Zoey_Globals_Macros ( __Alisha_ )

	With __Alisha_
		
		._Author = __Author
	
		'._Version_Raw = ._Version
		'._Version_Verbose = ._Version
		'._Version_Pretty = ._Version_Pretty
		._Title = ._Author & "'s " & ._Project & " (" & ._Version_Pretty & ")"
	
	End With

End Sub

Sub __Zoey_Globals_Macros ( __Alisha_ As __Alisha_Globals_Type )

	Dim	As Long Index = 0
	
	With __Alisha_
		
		._Path = __PATH__
		
		For Index = Len ( ._Path ) To 1 Step -1
			Select Case Mid ( ._Path, Index, 1 )
			Case "/"
				Mid ( ._Path, Index, 1 ) = "\"
			End Select
		Next Index
		
		._Root = ._Path
		
		._Project = __FILE__

		For Index = Len ( ._Project ) To 1 Step -1
			Select Case Mid ( ._Project, Index, 1 )
			Case "/"
				Mid ( ._Project, Index, 1 ) = "\"
			End Select
		Next Index
		
		Index = Instr ( ._Project, "\" )
		Do While Index > 0
			._Project = Mid ( ._Project, Index + 1 )
			Index = Instr( ._Project, "\" )
		Loop		

		Index = InstrRev ( ._Project, "." )
		Do While Index > 0
			._Project = Left ( ._Project, Index - 1 )
			Index = Instr( ._Project, "." )
		Loop		


		Do While Left ( ._Project, 1 ) = SP
			._Project = Mid ( ._Project, 2 )
		Loop
		
		Do While Right ( ._Project, 1 ) = SP
			._Project = Left ( ._Project, Len ( ._Project ) - 1 )
		Loop
		
		._Version = ._Path
		
		For Index As Long = Len ( ._Version ) To 1 Step -1
			Select Case Mid ( ._Version, Index, 1 )
			Case ")"
				._Version = Left ( ._Version, Index - 1 )
			End Select
		Next Index
		
		For Index As Long = Len ( ._Version ) To 1 Step -1
			Select Case Mid ( ._Version, Index, 1 )
			Case "("
				._Version = Mid ( ._Version, Index + 1 )
			End Select
		Next Index
		
		Do While Right ( ._Version, 1 ) = " "
			._Version = Left ( ._Version, Len ( ._Version ) - 1 )
		Loop
		
		Do While Left ( ._Version, 1 ) = " "
			._Version = Mid ( ._Version, 2 )
		Loop
		
		._Version_Pretty = ._Version
		
		For Index As Long = Len ( ._Version_Pretty ) To 1 Step -1
			Select Case Mid ( ._Version_Pretty, Index, 1 )
			Case "-", "."
				Mid ( ._Version_Pretty, Index, 1 ) = "."
			End Select
		Next Index
			
		Do While Right ( ._Root, 1 ) <> "\"
			._Root = Left ( ._Root, Len ( ._Root ) - 1 )
		Loop
	
	End With
	
End Sub
